exports.id = 281;
exports.ids = [281];
exports.modules = {

/***/ 9399:
/***/ ((module) => {

// Exports
module.exports = {
	"container": "Home_container__bCOhY",
	"footer": "Home_footer____T7K",
	"title": "Home_title__T09hD",
	"description": "Home_description__41Owk",
	"code": "Home_code__suPER",
	"grid": "Home_grid__GxQ85",
	"card": "Home_card___LpL1",
	"logo": "Home_logo__27_tb",
	"pagination": "Home_pagination__DFWeN",
	"pageLink": "Home_pageLink__s15iA",
	"pageItem": "Home_pageItem__iIeDc",
	"pageItemActive": "Home_pageItemActive__lGNNa"
};


/***/ }),

/***/ 1812:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

const Document = ({ data  })=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
        className: `hover:underline ${data.emphasis ? "font-bold" : ""}`,
        href: data.file?.url,
        style: {
            color: data.hex_color,
            fontSize: `${data.text_size}rem`
        },
        target: `${data.new_tab ? "_blank" : "_self"}`,
        rel: "noopener noreferrer",
        title: data.scroll_text,
        children: data.title
    });
};
Document.defaultProps = {
    data: {
        title: "",
        file: null,
        scroll_text: "",
        emphasis: false,
        hex_color: "#000000",
        text_size: 1,
        new_tab: true
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Document);


/***/ }),

/***/ 1798:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5341);
/* harmony import */ var _Document__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1812);
/* harmony import */ var _RumbleFrame__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6981);
/* harmony import */ var _TextLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4726);
/* harmony import */ var _Tweet__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1972);
/* harmony import */ var _YoutubeFrame__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9893);







const FeaturedPost = ({ post  })=>{
    const postTypeRendering = (type)=>{
        switch(type.__component){
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.TEXT */ .HH.TEXT:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_TextLink__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                    data: type
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.DOCUMENT */ .HH.DOCUMENT:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Document__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                    data: type
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.TWITTER */ .HH.TWITTER:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Tweet__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    data: type,
                    isFeatured: true
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.YOUTUBE */ .HH.YOUTUBE:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_YoutubeFrame__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                    data: type,
                    isFeatured: true
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.RUMBLE */ .HH.RUMBLE:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_RumbleFrame__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    data: type,
                    isFeatured: true
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.IMAGE */ .HH.IMAGE:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
                    href: type.img_url + "?utm_source=tickingbomb.com",
                    target: "_blank",
                    rel: "noopener noreferrer",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("img", {
                        loading: "lazy",
                        className: "object-contain max-w-full",
                        style: {
                            width: type.img_size + "rem"
                        },
                        src: type.img_source ? type.img_source : type.image.url,
                        alt: "alternativeText",
                        title: type.scroll_text
                    })
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.LONG_TEXT */ .HH.LONG_TEXT:
                let content = type.content.replace(/src="/g, `src=\"${_utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .BACKEND_URL */ .z0}`).replace(/&lt;hr&gt;/g, "<hr>");
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    dangerouslySetInnerHTML: {
                        __html: content
                    },
                    className: "prose lg:prose-xl"
                });
            default:
                break;
        }
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "p-2 w-full",
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
            className: "mt-1 flex flex-col gap-2 items-center justify-center text-center w-full",
            children: [
                post.show_title && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                    className: "text-5xl font-bold uppercase",
                    children: post.post_title
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    className: "flex flex-col gap-5 w-full",
                    children: post.type?.map((type, index)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "w-full flex flex-col items-center text-center",
                            style: index < 3 ? {
                                fontFamily: '"Arial Black", Arial, sans-serif'
                            } : {
                                lineHeight: "2"
                            },
                            children: postTypeRendering(type)
                        }, type.__component + type.id)
                    )
                })
            ]
        })
    });
};
FeaturedPost.defaultProps = {
    post: {}
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FeaturedPost);


/***/ }),

/***/ 1220:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ components_PageLayout)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: ./node_modules/next/image.js
var next_image = __webpack_require__(5675);
var image_default = /*#__PURE__*/__webpack_require__.n(next_image);
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
var link_default = /*#__PURE__*/__webpack_require__.n(next_link);
;// CONCATENATED MODULE: ./assets/ticking-bomb-logo.png
/* harmony default export */ const ticking_bomb_logo = ({"src":"/_next/static/media/ticking-bomb-logo.468865a7.png","height":640,"width":3051,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAACCAMAAABSSm3fAAAAD1BMVEUKBwkCAgICAgMODg4LCw3TNRoDAAAABXRSTlM7JC5allAhXwoAAAAJcEhZcwAALiMAAC4jAXilP3YAAAAZSURBVHicBcGBAQAgDMMg0vn/zYJqzyYcPgDQABLLQ4bQAAAAAElFTkSuQmCC"});
;// CONCATENATED MODULE: ./assets/social-icons/facebook.svg
/* harmony default export */ const facebook = ({"src":"/_next/static/media/facebook.cbbff964.svg","height":512,"width":512});
;// CONCATENATED MODULE: ./assets/social-icons/youtube.svg
/* harmony default export */ const youtube = ({"src":"/_next/static/media/youtube.caef206c.svg","height":512,"width":576});
;// CONCATENATED MODULE: ./assets/social-icons/reddit.svg
/* harmony default export */ const reddit = ({"src":"/_next/static/media/reddit.74154a13.svg","height":512,"width":512});
;// CONCATENATED MODULE: ./assets/social-icons/twitter.svg
/* harmony default export */ const twitter = ({"src":"/_next/static/media/twitter.a8b7fd09.svg","height":24,"width":24});
;// CONCATENATED MODULE: ./assets/social-icons/gmail.svg
/* harmony default export */ const gmail = ({"src":"/_next/static/media/gmail.cd85119b.svg","height":24,"width":24});
;// CONCATENATED MODULE: ./assets/social-icons/gotomeeting.svg
/* harmony default export */ const gotomeeting = ({"src":"/_next/static/media/gotomeeting.5b640771.svg","height":24,"width":24});
;// CONCATENATED MODULE: ./assets/social-icons/podcast.svg
/* harmony default export */ const podcast = ({"src":"/_next/static/media/podcast.e4e913f2.svg","height":24,"width":24});
;// CONCATENATED MODULE: ./assets/social-icons/skype.svg
/* harmony default export */ const skype = ({"src":"/_next/static/media/skype.cda5753f.svg","height":24,"width":24});
;// CONCATENATED MODULE: ./assets/social-icons/telegram.svg
/* harmony default export */ const telegram = ({"src":"/_next/static/media/telegram.1ac6881c.svg","height":24,"width":24});
;// CONCATENATED MODULE: ./assets/social-icons/vimeo.svg
/* harmony default export */ const vimeo = ({"src":"/_next/static/media/vimeo.1cd789d8.svg","height":24,"width":24});
;// CONCATENATED MODULE: ./assets/social-icons/zoom.jpg
/* harmony default export */ const zoom = ({"src":"/_next/static/media/zoom.9f3e6bb1.jpg","height":292,"width":292,"blurDataURL":"data:image/jpeg;base64,/9j/2wBDAAoHBwgHBgoICAgLCgoLDhgQDg0NDh0VFhEYIx8lJCIfIiEmKzcvJik0KSEiMEExNDk7Pj4+JS5ESUM8SDc9Pjv/2wBDAQoLCw4NDhwQEBw7KCIoOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozv/wAARCAAIAAgDASIAAhEBAxEB/8QAFQABAQAAAAAAAAAAAAAAAAAAAAb/xAAhEAAABAUFAAAAAAAAAAAAAAAAAhETAQMEBRIHITEygf/EABQBAQAAAAAAAAAAAAAAAAAAAAD/xAAUEQEAAAAAAAAAAAAAAAAAAAAA/9oADAMBAAIRAxEAPwChpD6qQv1SWdKojW5yLRjt9HIcY7rgqL6AAA//2Q=="});
;// CONCATENATED MODULE: ./assets/social-icons/bitchute.jpg
/* harmony default export */ const bitchute = ({"src":"/_next/static/media/bitchute.cade3810.jpg","height":512,"width":512,"blurDataURL":"data:image/jpeg;base64,/9j/2wBDAAoHBwgHBgoICAgLCgoLDhgQDg0NDh0VFhEYIx8lJCIfIiEmKzcvJik0KSEiMEExNDk7Pj4+JS5ESUM8SDc9Pjv/2wBDAQoLCw4NDhwQEBw7KCIoOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozv/wAARCAAIAAgDASIAAhEBAxEB/8QAFQABAQAAAAAAAAAAAAAAAAAAAAX/xAAeEAACAgICAwAAAAAAAAAAAAABAgQFAAMGERMhMv/EABQBAQAAAAAAAAAAAAAAAAAAAAD/xAAUEQEAAAAAAAAAAAAAAAAAAAAA/9oADAMBAAIRAxEAPwClUzI1daeWZBsLHmrSnRtTHcmsIzkAg/A1KnvvrGMYH//Z"});
;// CONCATENATED MODULE: ./assets/social-icons/clubhouse.jpg
/* harmony default export */ const clubhouse = ({"src":"/_next/static/media/clubhouse.e0eadf90.jpg","height":204,"width":247,"blurDataURL":"data:image/jpeg;base64,/9j/2wBDAAoHBwgHBgoICAgLCgoLDhgQDg0NDh0VFhEYIx8lJCIfIiEmKzcvJik0KSEiMEExNDk7Pj4+JS5ESUM8SDc9Pjv/2wBDAQoLCw4NDhwQEBw7KCIoOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozv/wAARCAAHAAgDASIAAhEBAxEB/8QAFQABAQAAAAAAAAAAAAAAAAAAAAb/xAAeEAABAwUBAQAAAAAAAAAAAAADAAEEAhESIVExQf/EABQBAQAAAAAAAAAAAAAAAAAAAAD/xAAUEQEAAAAAAAAAAAAAAAAAAAAA/9oADAMBAAIRAxEAPwC9lgNEnjISZUOTVTjGa2eXy13833rb0iIg/9k="});
;// CONCATENATED MODULE: ./assets/social-icons/gettr.jpg
/* harmony default export */ const gettr = ({"src":"/_next/static/media/gettr.0976c554.jpg","height":512,"width":512,"blurDataURL":"data:image/jpeg;base64,/9j/2wBDAAoHBwgHBgoICAgLCgoLDhgQDg0NDh0VFhEYIx8lJCIfIiEmKzcvJik0KSEiMEExNDk7Pj4+JS5ESUM8SDc9Pjv/2wBDAQoLCw4NDhwQEBw7KCIoOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozv/wAARCAAIAAgDASIAAhEBAxEB/8QAFQABAQAAAAAAAAAAAAAAAAAAAAf/xAAeEAACAgICAwAAAAAAAAAAAAACBAEDABEGEiExgf/EABQBAQAAAAAAAAAAAAAAAAAAAAD/xAAUEQEAAAAAAAAAAAAAAAAAAAAA/9oADAMBAAIRAxEAPwCgO1Mvc8SotKyFU1iaEQuIRMpnrHcdaKYn15+YxjA//9k="});
;// CONCATENATED MODULE: ./assets/social-icons/rumble.jpg
/* harmony default export */ const rumble = ({"src":"/_next/static/media/rumble.3b47d9e4.jpg","height":512,"width":512,"blurDataURL":"data:image/jpeg;base64,/9j/2wBDAAoHBwgHBgoICAgLCgoLDhgQDg0NDh0VFhEYIx8lJCIfIiEmKzcvJik0KSEiMEExNDk7Pj4+JS5ESUM8SDc9Pjv/2wBDAQoLCw4NDhwQEBw7KCIoOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozv/wAARCAAIAAgDASIAAhEBAxEB/8QAFQABAQAAAAAAAAAAAAAAAAAAAAX/xAAjEAAABAMJAAAAAAAAAAAAAAAAERITAQIVBQYUFiMkMjNh/8QAFAEBAAAAAAAAAAAAAAAAAAAAAP/EABQRAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhEDEQA/AJ1mxvZmSbA1Ksubg3Em9HuXptt8U+EAAA//2Q=="});
;// CONCATENATED MODULE: ./assets/social-icons/truthsocial.jpg
/* harmony default export */ const truthsocial = ({"src":"/_next/static/media/truthsocial.283c664b.jpg","height":209,"width":209,"blurDataURL":"data:image/jpeg;base64,/9j/2wBDAAoHBwgHBgoICAgLCgoLDhgQDg0NDh0VFhEYIx8lJCIfIiEmKzcvJik0KSEiMEExNDk7Pj4+JS5ESUM8SDc9Pjv/2wBDAQoLCw4NDhwQEBw7KCIoOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozv/wAARCAAIAAgDASIAAhEBAxEB/8QAFQABAQAAAAAAAAAAAAAAAAAAAAX/xAAfEAACAQQCAwAAAAAAAAAAAAABAwACBAUGETESIUH/xAAUAQEAAAAAAAAAAAAAAAAAAAAA/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAwDAQACEQMRAD8Ar5jENsNzVbuutkZiEY4M87V7q6qnVPPokd8A9fAIiIH/2Q=="});
;// CONCATENATED MODULE: ./assets/social-icons/link.svg
/* harmony default export */ const social_icons_link = ({"src":"/_next/static/media/link.1a3c1314.svg","height":16,"width":16});
// EXTERNAL MODULE: ./utils/pages.constants.js
var pages_constants = __webpack_require__(5341);
// EXTERNAL MODULE: ./components/FeaturedPost.js
var FeaturedPost = __webpack_require__(1798);
;// CONCATENATED MODULE: ./components/Footer.js























const selectIcon = (title)=>{
    switch(title){
        case "facebook":
            return facebook;
        case "twitter":
            return twitter;
        case "youtube":
            return youtube;
        case "reddit":
            return reddit;
        case "contact":
            return gmail;
        case "gotomeeting":
            return gotomeeting;
        case "podcast":
            return podcast;
        case "skype":
            return skype;
        case "telegram":
            return telegram;
        case "vimeo":
            return vimeo;
        case "zoom":
            return zoom;
        case "bitchute":
            return bitchute;
        case "clubhouse":
            return clubhouse;
        case "gettr":
            return gettr;
        case "rumble":
            return rumble;
        case "truthsocial":
            return truthsocial;
        default:
            return social_icons_link;
    }
};
const Footer = ({ footerContacts , footerPost  })=>{
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("footer", {
        className: "my-10 space-y-4",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("hr", {}),
            footerPost && /*#__PURE__*/ jsx_runtime_.jsx(FeaturedPost/* default */.Z, {
                post: footerPost
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "relative w-full h-28",
                children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                    href: pages_constants/* PATHS.home */.yy.home,
                    children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                        children: /*#__PURE__*/ jsx_runtime_.jsx((image_default()), {
                            src: ticking_bomb_logo,
                            layout: "fill",
                            objectFit: "contain",
                            alt: "ticking-bomb logo"
                        })
                    })
                })
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "flex justify-center gap-12 font-semibold text-center mb-5",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                        href: pages_constants/* PATHS.contact */.yy.contact,
                        children: "Contact Us"
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("a", {
                        href: pages_constants/* PATHS.contact */.yy.contact,
                        children: "Advertise with us"
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("a", {
                        href: pages_constants/* PATHS.contact */.yy.contact,
                        children: "About us"
                    })
                ]
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "flex justify-center gap-4 lg:gap-8",
                children: footerContacts?.map((contact)=>/*#__PURE__*/ jsx_runtime_.jsx("a", {
                        href: contact.url + "?utm_source=tickingbomb.com",
                        children: /*#__PURE__*/ jsx_runtime_.jsx((image_default()), {
                            width: 32,
                            height: 32,
                            src: selectIcon(contact.title),
                            alt: contact.title
                        })
                    }, contact.id)
                )
            }),
            footerPost?.footer_bottom_text && (()=>{
                let content = footerPost.footer_bottom_text.replace(/src="/g, `src=\"${pages_constants/* BACKEND_URL */.z0}`).replace(/&lt;hr&gt;/g, "<hr>");
                return /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    dangerouslySetInnerHTML: {
                        __html: content
                    },
                    className: "max-w-full text-center prose lg:prose-xl m-0"
                });
            })()
        ]
    });
};
Footer.defaultProps = {
    footerContacts: [],
    footerPost: {}
};
/* harmony default export */ const components_Footer = (Footer);

// EXTERNAL MODULE: external "@heroicons/react/outline"
var outline_ = __webpack_require__(8768);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
// EXTERNAL MODULE: ./utils/pages.data.js
var pages_data = __webpack_require__(7324);
;// CONCATENATED MODULE: ./components/Navbar.js






const Navbar = ()=>{
    const { 0: showNavbar , 1: setShowNavbar  } = (0,external_react_.useState)(false);
    const { 0: pages , 1: setPages  } = (0,external_react_.useState)([]);
    (0,external_react_.useEffect)(()=>{
        const fetchPages = async ()=>{
            const data = await (0,pages_data/* getAllPages */.K0)();
            const tempPages = data?.map((page)=>({
                    title: page.attributes.page_name,
                    id: page.id
                })
            );
            setPages(tempPages);
        };
        fetchPages();
    }, []);
    const toggleNavbar = ()=>{
        setShowNavbar(!showNavbar);
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("nav", {
        className: "relative",
        children: [
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "hidden lg:flex justify-center px-10 pt-6 sm:px-20 text-base text-template-black whitespace-nowrap space-x-2 sm:space-x-4 scrollbar-hide",
                children: [
                    pages_constants/* NAVBAR_ITEMS.map */.yN.map((navItem, index)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "flex",
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                                    className: "pr-4 cursor-pointer transition duration-100 transform hover:scale-125 active:text-red-500",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: navItem.navLink,
                                        children: navItem.title
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                    className: "w-0.5 h-full bg-slate-200"
                                })
                            ]
                        }, index)
                    ),
                    pages?.map((page)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                            className: "flex",
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                                    className: "pr-4 cursor-pointer transition duration-100 transform hover:scale-125 active:text-red-500",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: `/topic/${page.id}`,
                                        children: page.title
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                    className: "w-0.5 h-full bg-slate-200"
                                })
                            ]
                        }, page.id)
                    ),
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                        className: "flex",
                        children: [
                            /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                                className: "pr-4 cursor-pointer transition duration-100 transform hover:scale-125 active:text-red-500",
                                children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                    href: "/contact",
                                    children: "Contact"
                                })
                            }),
                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                className: "w-0.5 h-full bg-slate-200"
                            })
                        ]
                    })
                ]
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("section", {
                className: `right-0 top-0 bottom-0 fixed flex flex-col justify-start w-3/4 ${showNavbar ? "h-full" : "h-0"} bg-white z-10`,
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("header", {
                        className: "lg:hidden w-full h-20 flex justify-end",
                        children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                            className: "btn flex justify-center items-center w-20 h-20",
                            onClick: toggleNavbar,
                            children: showNavbar ? /*#__PURE__*/ jsx_runtime_.jsx(outline_.XCircleIcon, {
                                className: "h-6 w-6 text-black overflow-hidden"
                            }) : /*#__PURE__*/ jsx_runtime_.jsx(outline_.MenuIcon, {
                                className: "h-6 w-6 text-black"
                            })
                        })
                    }),
                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("section", {
                        className: showNavbar ? "block h-full" : "hidden",
                        children: [
                            /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                                className: "text-2xl text-center font-bold mb-6",
                                children: "Menu"
                            }),
                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                className: "overflow-y-scroll flex flex-col items-center gap-1 h-full",
                                children: [
                                    pages_constants/* NAVBAR_ITEMS.map */.yN.map((navItem, index)=>/*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                            href: navItem.navLink,
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                                className: "w-full text-center text-lg py-3",
                                                children: navItem.title
                                            })
                                        }, index)
                                    ),
                                    pages?.map((page)=>/*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                            href: `/topic/${page.id}`,
                                            children: /*#__PURE__*/ jsx_runtime_.jsx("button", {
                                                onClick: toggleNavbar,
                                                className: "w-full text-center text-lg py-3",
                                                children: page.title
                                            })
                                        }, page.id)
                                    ),
                                    /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                        className: "flex",
                                        children: [
                                            /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                                                className: "pr-4 cursor-pointer transition duration-100 transform hover:scale-125 active:text-red-500",
                                                children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                                    href: "/contact",
                                                    children: "Contact"
                                                })
                                            }),
                                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                                className: "w-0.5 h-full bg-slate-200"
                                            })
                                        ]
                                    })
                                ]
                            })
                        ]
                    })
                ]
            })
        ]
    });
};
/* harmony default export */ const components_Navbar = (Navbar);

// EXTERNAL MODULE: ./utils/helpers.js
var helpers = __webpack_require__(7278);
;// CONCATENATED MODULE: ./components/PageLayout.js







const PageLayout = ({ className , children , pageTitle , configUrl , tickingHeader , footerPost , footerContacts ,  })=>{
    (0,external_react_.useEffect)(()=>{
        const tickingBombDates = {
            after_expiry_url: tickingHeader?.after_expiry_url,
            before_expiry_url: tickingHeader?.before_expiry_url
        };
        localStorage.setItem("TICKINGBOMB_TIMER_LINKS", JSON.stringify(tickingBombDates));
    }, [
        tickingHeader?.after_expiry_url,
        tickingHeader?.before_expiry_url
    ]);
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: className,
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx(components_Navbar, {}),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "flex flex-col items-center mb-10",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "w-full lg:w-3/4 mt-10 md:mt-4 flex justify-center items-center",
                        children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                            href: tickingHeader?.logo_url ? tickingHeader?.logo_url : pages_constants/* PATHS.home */.yy.home,
                            children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                children: /*#__PURE__*/ jsx_runtime_.jsx("img", {
                                    src: tickingHeader?.logo.url,
                                    alt: "Logo"
                                })
                            })
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                        className: "text-4xl uppercase tracking-widest text-center",
                        children: tickingHeader?.motto
                    }),
                    tickingHeader && /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        title: tickingHeader.text,
                        className: "w-full flex justify-center",
                        children: /*#__PURE__*/ jsx_runtime_.jsx("iframe", {
                            className: (0,helpers/* classNames */.AK)("w-full", tickingHeader.size === 2 ? "max-w-2xl" : tickingHeader.size === 3 ? "max-w-3xl" : "max-w-4xl"),
                            src: `/ticking.html?date=${tickingHeader.date}`
                        })
                    })
                ]
            }),
            configUrl && /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "flex justify-center mb-10",
                children: /*#__PURE__*/ jsx_runtime_.jsx("img", {
                    src: pages_constants/* BACKEND_URL */.z0 + configUrl,
                    className: `w-44`,
                    alt: "config logo"
                })
            }),
            pageTitle && /*#__PURE__*/ jsx_runtime_.jsx("h1", {
                className: "py-2 text-2xl font-bold text-white bg-black uppercase text-center",
                children: pageTitle
            }),
            children,
            /*#__PURE__*/ jsx_runtime_.jsx(components_Footer, {
                footerContacts: footerContacts?.results,
                footerPost: footerPost
            })
        ]
    });
};
PageLayout.defaultProps = {
    className: "",
    pageTitle: ""
};
/* harmony default export */ const components_PageLayout = (PageLayout);


/***/ }),

/***/ 6981:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7278);


const RumbleFrame = ({ data , isFeatured  })=>{
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        // id = "video"
        className: (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_1__/* .classNames */ .AK)("relative w-full h-full flex flex-col", isFeatured ? "items-center" : "items-start"),
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h3", {
                className: (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_1__/* .classNames */ .AK)(data.title_emphasis && "font-bold"),
                style: {
                    color: data.hex_color,
                    fontSize: `${data.text_size}rem`,
                    minHeight: `${data.text_size}rem`
                },
                children: data.title
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                style: {
                    position: "relative",
                    width: `${data.img_size}%`,
                    aspectRatio: "16 / 9",
                    maxWidth: "100%",
                    overflow: "hidden"
                },
                className: "max-w-3xl",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("iframe", {
                    src: data.url,
                    style: {
                        position: "absolute",
                        top: 0,
                        left: 0,
                        width: "100%",
                        height: "100%",
                        border: 0
                    },
                    allowFullScreen: true
                })
            })
        ]
    });
};
RumbleFrame.defaultFrame = {
    data: {
        title: "",
        url: "",
        img_size: 50,
        emphasis: false,
        hex_color: "#000000",
        text_size: 1
    },
    isFeatured: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RumbleFrame);


/***/ }),

/***/ 4726:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7278);


const TextLink = ({ data  })=>{
    const maxMobileTextSize = data.text_size > 3 ? "max-sm:!text-5xl" : "";
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
        className: (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_1__/* .classNames */ .AK)("leading-none text-template-black visited:!text-[#878787] hover:underline", data.emphasis && "font-bold", maxMobileTextSize),
        href: data.url + "?utm_source=tickingbomb.com",
        style: {
            color: data.hex_color,
            fontSize: `${data.text_size}rem`
        },
        target: `${data.new_tab ? "_blank" : "_self"}`,
        rel: "noopener noreferrer",
        title: data.scroll_text,
        children: data.title
    });
};
TextLink.defaultProps = {
    data: {
        title: "",
        emphasis: false,
        url: "#",
        hex_color: "#000000",
        new_tab: false,
        text_size: 1,
        scroll_text: ""
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextLink);


/***/ }),

/***/ 1972:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7278);


const Tweet = ({ data , isFeatured  })=>{
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_1__/* .classNames */ .AK)("flex flex-col", isFeatured ? "items-center" : "items-start"),
        style: {
            width: `${data.img_size}%`,
            height: "auto"
        },
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h3", {
                className: `${data.title_emphasis ? "font-bold" : ""}`,
                style: {
                    color: data.hex_color,
                    fontSize: `${data.text_size}rem`
                },
                children: data.title
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("blockquote", {
                className: "twitter-tweet",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
                    href: data.url
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("script", {
                async: true,
                src: "https://platform.twitter.com/widgets.js"
            })
        ]
    });
};
Tweet.defaultProps = {
    data: {
        title: "",
        url: "",
        img_size: 100,
        emphasis: false,
        hex_color: "#000000",
        text_size: 1
    },
    isFeatured: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tweet);


/***/ }),

/***/ 9893:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7278);


const YoutubeFrame = ({ data , isFeatured  })=>{
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_1__/* .classNames */ .AK)("relative w-full h-full flex flex-col ", isFeatured ? "items-center" : "items-start"),
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                className: (0,_utils_helpers__WEBPACK_IMPORTED_MODULE_1__/* .classNames */ .AK)(data.title_emphasis && "font-bold"),
                style: {
                    color: data.hex_color,
                    fontSize: `${data.text_size}rem`
                },
                children: data.title
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                style: {
                    position: "relative",
                    width: `${data.img_size}%`,
                    aspectRatio: "16 / 9",
                    maxWidth: "100%",
                    overflow: "hidden"
                },
                className: "youtubeiframe max-w-3xl",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("iframe", {
                    src: `https://www.youtube.com/embed/${data.video_id}`,
                    style: {
                        position: "absolute",
                        top: 0,
                        left: 0,
                        width: "100%",
                        height: "100%",
                        border: 0
                    },
                    allowFullScreen: true
                })
            })
        ]
    });
};
YoutubeFrame.defaultFrame = {
    data: {
        title: "",
        video_id: "",
        img_size: 50,
        emphasis: false,
        hex_color: "#000000",
        text_size: 1
    },
    isFeatured: false
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (YoutubeFrame);


/***/ }),

/***/ 7278:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AK": () => (/* binding */ classNames),
/* harmony export */   "C1": () => (/* binding */ splitArray),
/* harmony export */   "R8": () => (/* binding */ convertXLtoJSON),
/* harmony export */   "p6": () => (/* binding */ formatDate)
/* harmony export */ });
/* unused harmony export paginate */
/* harmony import */ var xml2js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(855);
/* harmony import */ var xml2js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(xml2js__WEBPACK_IMPORTED_MODULE_0__);

const classNames = (...classes)=>{
    return classes.filter(Boolean).join(" ");
};
// a function to split an array into 3 subarrays of equal length (or as close as possible) and return them in an array of arrays
const splitArray = (array)=>{
    const arrayLength = array.length;
    const splitArray1 = [];
    let i = 0;
    while(i < arrayLength){
        splitArray1.push(array.slice(i, i + Math.ceil(arrayLength / 3)));
        i += Math.ceil(arrayLength / 3);
    }
    return splitArray1;
};
const paginate = (items, pageNumber, pageSize)=>{
    const startIndex = (pageNumber - 1) * pageSize;
    return items.slice(startIndex, startIndex + pageSize);
};
const convertXLtoJSON = async (xml)=>{
    const xmlToJson = await xml2js__WEBPACK_IMPORTED_MODULE_0___default().parseStringPromise(xml).catch((e)=>{
        throw e;
    }).then((r)=>JSON.stringify(r, null, 4)
    );
    return JSON.parse(xmlToJson);
};
const formatDate = (dateString)=>{
    const date = new Date(dateString);
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, "0"); // Months are 0-based
    const day = String(date.getDate()).padStart(2, "0");
    return `${year}-${month}-${day}`;
};


/***/ }),

/***/ 5341:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HH": () => (/* binding */ POST_COMPONENT_TYPE),
/* harmony export */   "T5": () => (/* binding */ API_URL),
/* harmony export */   "lr": () => (/* binding */ SOCIAL_TYPE),
/* harmony export */   "yN": () => (/* binding */ NAVBAR_ITEMS),
/* harmony export */   "yy": () => (/* binding */ PATHS),
/* harmony export */   "z0": () => (/* binding */ BACKEND_URL)
/* harmony export */ });
const SOCIAL_TYPE = {
    Twitter: "Twitter",
    YouTube: "YouTube"
};
const NAVBAR_ITEMS = [
    {
        title: "Home",
        navLink: "/"
    },
    {
        title: "Exclusive",
        navLink: "/exclusive"
    },
    {
        title: "Carpet Bomb",
        navLink: "/carpet-bomb"
    },
    {
        title: "Bookmarks",
        navLink: "/bookmarks"
    },
    {
        title: "Tools",
        navLink: "/tools"
    }
];
const POST_COMPONENT_TYPE = {
    DOCUMENT: "post-type.document",
    TWITTER: "post-type.twitter",
    YOUTUBE: "post-type.youtube",
    TEXT: "post-type.text",
    LONG_TEXT: "post-type.long-text",
    RUMBLE: "post-type.rumble",
    IMAGE: "post-type.image"
};
const API_URL = "https://admin.tickingbomb.com";
const BACKEND_URL = "https://admin.tickingbomb.com" || 0;
const PATHS = {
    home: "/",
    about: "/about",
    contact: "/contact",
    resources: "/resources",
    topics: "/topics"
};


/***/ }),

/***/ 7324:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DN": () => (/* binding */ getExclusiveData),
/* harmony export */   "IZ": () => (/* binding */ getCarpetBombsData),
/* harmony export */   "K0": () => (/* binding */ getAllPages),
/* harmony export */   "QL": () => (/* binding */ getToolsData),
/* harmony export */   "WK": () => (/* binding */ getExclusiveUnformatedData),
/* harmony export */   "WV": () => (/* binding */ getHeaderFooterData),
/* harmony export */   "_S": () => (/* binding */ getExclusivePostBySlug),
/* harmony export */   "c$": () => (/* binding */ getConfigData),
/* harmony export */   "g": () => (/* binding */ getContactData),
/* harmony export */   "g8": () => (/* binding */ getBookmarkssData),
/* harmony export */   "jh": () => (/* binding */ getResources),
/* harmony export */   "r_": () => (/* binding */ getHomepageData),
/* harmony export */   "um": () => (/* binding */ getPageData)
/* harmony export */ });
/* unused harmony export getRssData */
/* harmony import */ var _pages_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5341);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7278);


const getAllPages = async ()=>{
    try {
        const pathsData = (await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/pages`)).json()).data;
        return pathsData;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const setImagesPath = (posts)=>{
    posts.forEach((post)=>{
        if (post.image?.url) post.image.url = _pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .BACKEND_URL */ .z0 + post.image.url;
        post.type?.forEach((type)=>{
            if (type.__component === _pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .POST_COMPONENT_TYPE.DOCUMENT */ .HH.DOCUMENT && type.file?.url) {
                type.file.url = _pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .BACKEND_URL */ .z0 + type.file.url;
            } else if (type.__component === _pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .POST_COMPONENT_TYPE.IMAGE */ .HH.IMAGE && type.image?.url) {
                type.image.url = _pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .BACKEND_URL */ .z0 + type.image.url;
            }
        });
    });
};
const setPageImagePath = (posts)=>{
    posts.forEach((post)=>{
        if (!post.attributes.image.data) return;
        let url = _pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .BACKEND_URL */ .z0 + post.attributes.image.data.attributes.url;
        post.attributes.image.url = url;
    });
};
const getPageData = async (pageId)=>{
    const pagePostData = (await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/pages/${pageId}`)).json()).data.attributes;
    setPageImagePath(pagePostData.posts.data);
    return pagePostData;
};
const getHeaderFooterData = async ()=>{
    try {
        const headerFooterData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/header-footer`)).json();
        if (headerFooterData.tickingHeader) headerFooterData.tickingHeader.logo.url = _pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .BACKEND_URL */ .z0 + headerFooterData.tickingHeader.logo.url;
        if (headerFooterData.footerPost) setImagesPath([
            headerFooterData.footerPost
        ]);
        return headerFooterData;
    } catch (error) {
        console.log(error);
        return;
    }
};
const getHomepageData = async ()=>{
    try {
        const homepageData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/home`)).json();
        if (homepageData.featuredPost) setImagesPath([
            homepageData.featuredPost
        ]);
        setImagesPath(homepageData.leftTrending.results);
        setImagesPath(homepageData.rightTrending.results);
        setImagesPath(homepageData.body.results);
        return homepageData;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getResources = async ()=>{
    try {
        const resources = (await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/resource-page`)).json())?.data?.attributes;
        return resources;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getContactData = async ()=>{
    try {
        const contactData = (await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/contact-page`)).json()).data.attributes;
        return contactData;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getToolsData = async ()=>{
    try {
        const topicsData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/tools?sort=createdAt:desc`)).json();
        return topicsData;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getBookmarkssData = async ()=>{
    try {
        const topicsData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/bookmarks?sort=createdAt:desc`)).json();
        return topicsData;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getCarpetBombsData = async ()=>{
    try {
        const topicsData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/carpet-bombs?sort=createdAt:desc`)).json();
        let completeRssFeed = topicsData;
        const rssPromises = [];
        for(let i = 0; i < topicsData.data.length; i++){
            for(let j = 0; j < topicsData.data[i].attributes.level_2.length; j++){
                for(let k = 0; k < topicsData.data[i].attributes.level_2[j].links.length; k++){
                    const link = topicsData.data[i].attributes.level_2[j].links[k];
                    const rssPromise = getRssData(link.rss).then((rssData)=>{
                        completeRssFeed.data[i].attributes.level_2[j].links[k].rss = rssData;
                    });
                    rssPromises.push(rssPromise);
                }
            }
        }
        await Promise.all(rssPromises);
        return completeRssFeed;
    } catch (error) {
        console.log(error);
        return [];
    }
};
function groupByDate(data) {
    // Create an empty object to store the grouped data
    const groupedData = {};
    // Iterate over each item in the data array
    data.forEach((item)=>{
        console.log(item);
        const date = item?.attributes?.date != null ? item.attributes.date : item.attributes.publishedAt.split("T")[0];
        // If the date does not exist in the groupedData object, create a new array for it
        if (!groupedData[date]) {
            groupedData[date] = [];
        }
        // Push the current item to the array corresponding to its date
        groupedData[date].push(item);
    });
    // Convert the grouped data object into an array of objects with date and items properties
    const result = Object.keys(groupedData).map((date)=>({
            date: date,
            items: groupedData[date]
        })
    );
    return result;
}
const getExclusiveData = async (page = 1)=>{
    try {
        const topicsData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/exclusives?pagination[page]=${page}&sort=publishedAt:desc`)).json();
        return groupByDate(topicsData?.data);
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getExclusiveUnformatedData = async ()=>{
    try {
        const topicsData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/exclusives`)).json();
        return topicsData;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getExclusivePostBySlug = async (slug)=>{
    try {
        const exclusive = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/slugify/slugs/exclusive/${slug}?populate[0]=content.image&populate[1]=content.file`)).json();
        return exclusive;
    } catch (error) {
        console.log(error);
        return {
            data: []
        };
    }
};
const getConfigData = async ()=>{
    try {
        const configData = await (await fetch(`${_pages_constants__WEBPACK_IMPORTED_MODULE_0__/* .API_URL */ .T5}/api/page-config`)).json();
        return configData;
    } catch (error) {
        console.log(error);
        return [];
    }
};
const getRssData = async (rssLink)=>{
    try {
        const rssXML = await (await fetch(rssLink)).text();
        const rssJson = await (0,_helpers__WEBPACK_IMPORTED_MODULE_1__/* .convertXLtoJSON */ .R8)(rssXML);
        return rssJson;
    } catch (error) {
        console.log(error);
        return [];
    }
};


/***/ })

};
;