"use strict";
(() => {
var exports = {};
exports.id = 335;
exports.ids = [335];
exports.modules = {

/***/ 5281:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ contact),
  "getStaticProps": () => (/* binding */ getStaticProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: ./styles/Home.module.css
var Home_module = __webpack_require__(9399);
var Home_module_default = /*#__PURE__*/__webpack_require__.n(Home_module);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(968);
// EXTERNAL MODULE: ./components/PageLayout.js + 20 modules
var PageLayout = __webpack_require__(1220);
;// CONCATENATED MODULE: external "react-google-recaptcha"
const external_react_google_recaptcha_namespaceObject = require("react-google-recaptcha");
var external_react_google_recaptcha_default = /*#__PURE__*/__webpack_require__.n(external_react_google_recaptcha_namespaceObject);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
;// CONCATENATED MODULE: external "next/router"
const router_namespaceObject = require("next/router");
// EXTERNAL MODULE: ./utils/pages.data.js
var pages_data = __webpack_require__(7324);
// EXTERNAL MODULE: ./utils/pages.constants.js
var pages_constants = __webpack_require__(5341);
// EXTERNAL MODULE: ./components/MetaHeader.jsx
var MetaHeader = __webpack_require__(2158);
;// CONCATENATED MODULE: ./pages/contact.js










const getStaticProps = async ()=>{
    const header_data = await (0,pages_data/* getHeaderFooterData */.WV)();
    const contact_data = await (0,pages_data/* getContactData */.g)();
    return {
        props: {
            ...header_data,
            contact_data
        },
        revalidate: 1
    };
};
const Contact = ({ tickingHeader , footerPost , footerContacts , contact_data ,  })=>{
    const { 0: validated , 1: setValidated  } = (0,external_react_.useState)(false);
    const router = (0,router_namespaceObject.useRouter)();
    const { 0: values , 1: setValues  } = (0,external_react_.useState)({
        name: "",
        email: "",
        message: ""
    });
    const onRecaptchaChange = (value)=>{
        if (value) setValidated(!!value);
    };
    const onChangeHandler = (name)=>(event)=>{
            setValues({
                ...values,
                [name]: event.target.value
            });
        }
    ;
    const onSubmit = async (event)=>{
        event.preventDefault();
        if (!validated) {
            alert("Please complete the reCaptcha first!");
            return;
        }
        const data = await (await fetch("/api/message", {
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify({
                data: values
            })
        })).json();
        if (data.error) {
            alert(data.error.message);
            return;
        }
        router.reload(window.location.pathname);
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: (Home_module_default()).container,
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx(MetaHeader/* default */.Z, {
                title: "Contact Us | Ticking Bomb"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx(PageLayout/* default */.Z, {
                pageTitle: "Contact Us",
                tickingHeader: tickingHeader,
                footerPost: footerPost,
                footerContacts: footerContacts,
                children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                    className: "w-full flex flex-col items-center",
                    children: [
                        contact_data?.text && (()=>{
                            let content = contact_data?.text.replace(/src="/g, `src=\"${pages_constants/* BACKEND_URL */.z0}`).replace(/&lt;hr&gt;/g, "<hr>");
                            return /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                dangerouslySetInnerHTML: {
                                    __html: content
                                },
                                className: "max-w-full text-center prose lg:prose-xl m-0"
                            });
                        })(),
                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)("form", {
                            className: "flex flex-col items-stretch py-5 my-5",
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("label", {
                                    className: "font-bold uppercase text-sm",
                                    children: "Name"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                    type: "text",
                                    name: "name",
                                    id: "name",
                                    onChange: onChangeHandler("name"),
                                    className: "mb-5 border border-template-input-border rounded-md p-1"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("label", {
                                    className: "font-bold uppercase text-sm",
                                    children: "Email"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                    type: "email",
                                    name: "email",
                                    id: "email",
                                    onChange: onChangeHandler("email"),
                                    className: "mb-5 border border-template-input-border rounded-md p-1"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("label", {
                                    className: "font-bold uppercase text-sm",
                                    children: "Message"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("textarea", {
                                    name: "message",
                                    id: "message",
                                    cols: "40",
                                    rows: "7",
                                    onChange: onChangeHandler("message"),
                                    className: "mb-5 border border-template-input-border rounded-md p-1"
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                    className: "py-6",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((external_react_google_recaptcha_default()), {
                                        sitekey: "6LdDWmMgAAAAAN8KhpCD5q2kCUG97YCxbwAGyC91",
                                        onChange: onRecaptchaChange
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx("input", {
                                    type: "submit",
                                    value: "SEND MESSAGE",
                                    onClick: onSubmit,
                                    className: "bg-template-black text-white p-4 text-sm rounded-md cursor-pointer"
                                })
                            ]
                        })
                    ]
                })
            })
        ]
    });
};
/* harmony default export */ const contact = (Contact);


/***/ }),

/***/ 8768:
/***/ ((module) => {

module.exports = require("@heroicons/react/outline");

/***/ }),

/***/ 2796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 4957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 4014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 5843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 8524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 8020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 4406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 4964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 3938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 9565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 4365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 1292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 6052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 4226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 5052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 9232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 4780:
/***/ ((module) => {

module.exports = require("next/script");

/***/ }),

/***/ 6689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 855:
/***/ ((module) => {

module.exports = require("xml2js");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [505,61,281,158], () => (__webpack_exec__(5281)));
module.exports = __webpack_exports__;

})();