const Document = ({ data }) => {
	return (
		<a
			className={`hover:underline ${
				data.emphasis ? 'font-bold' : ''
			}`}
			href={data.file?.url}
			style={{
				color: data.hex_color,
				fontSize: `${data.text_size}rem`,
			}}
			target={`${data.new_tab ? '_blank' : '_self'}`}
			rel='noopener noreferrer'
			title={data.scroll_text}
		>
			{data.title}
		</a>
	);
};

Document.defaultProps = {
	data: {
		title: '',
		file: null,
		scroll_text: '',
		emphasis: false,
		hex_color: '#000000',
		text_size: 1,
		new_tab: true,
	},
};
export default Document;
