import { BACKEND_URL, POST_COMPONENT_TYPE } from '../utils/pages.constants';
import Document from './Document';
import RumbleFrame from './RumbleFrame';
import TextLink from './TextLink';
import Tweet from './Tweet';
import YoutubeFrame from './YoutubeFrame';

const FeaturedPost = ({ post }) => {
	const postTypeRendering = (type) => {
		switch (type.__component) {
			case POST_COMPONENT_TYPE.TEXT:
				return <TextLink data={type} />;

			case POST_COMPONENT_TYPE.DOCUMENT:
				return <Document data={type} />;

			case POST_COMPONENT_TYPE.TWITTER:
				return <Tweet data={type} isFeatured={true} />;

			case POST_COMPONENT_TYPE.YOUTUBE:
				return <YoutubeFrame data={type} isFeatured={true} />;

			case POST_COMPONENT_TYPE.RUMBLE:
				return <RumbleFrame data={type} isFeatured={true} />;

			case POST_COMPONENT_TYPE.IMAGE:
				return (
					<a href={type.img_url + '?utm_source=tickingbomb.com'} 
					target='_blank' rel='noopener noreferrer'>
					
						<img
							loading='lazy'
							className='object-contain max-w-full'
							style={{ width: type.img_size + 'rem' }}
							src={type.img_source ? type.img_source : type.image.url}
							alt='alternativeText'
							title={type.scroll_text}
						/>
					</a>
				);

			case POST_COMPONENT_TYPE.LONG_TEXT:
				let content = type.content
					.replace(/src="/g, `src=\"${BACKEND_URL}`)
					.replace(/&lt;hr&gt;/g, '<hr>');
				return (
					<div
						dangerouslySetInnerHTML={{ __html: content }}
						className='prose lg:prose-xl'
					></div>
				);
			default:
				break;
		}
	};
	return (
		<div className='p-2 w-full'>
			<div className='mt-1 flex flex-col gap-2 items-center justify-center text-center w-full'>
				{post.show_title && (
					<h2 className='text-5xl font-bold uppercase'>{post.post_title}</h2>
				)}
				<div className="flex flex-col gap-5 w-full">
				{post.type?.map((type, index) => (
					<div
						key={type.__component + type.id}
						className='w-full flex flex-col items-center text-center'
						style={
							index < 3
								? {
										fontFamily: '"Arial Black", Arial, sans-serif',
										// lineHeight: '0',
								  }
								: { lineHeight: '2' }
						}
					>
						{postTypeRendering(type)}
					</div>
				))}
				</div>
			</div>
		</div>
	);
};

FeaturedPost.defaultProps = {
	post: {},
};

export default FeaturedPost;
