import React from 'react'

const FiltersSection = ({ topics, selectedFilter, selectedSubFilter,  handleFilterSelection,handleSubFilterSelection }) => {
    return (
        <>

            <div className='flex flex-row'>
                <div className='bg-template-bg-grey w-full lg:w-52 text-left'>
                    {/* <h2 className='font-bold text-lg pb-3'>Section 1 Filter</h2> */}
                    <div>
                        {/* topics */}
                        {topics?.map((topic, index) => (
                            <button
                                key={topic.id}
                                value={index}
                                className={`list-none p-1 cursor-pointer text-lg hover:bg-template-input-border w-full text-left uppercase  ${selectedFilter == index ? 'bg-black text-white' : ''
                                    }`}
                                onClick={handleFilterSelection}
                            >
                                {topic.attributes.title}
                            </button>
                        ))}
                    </div>
                </div>
                {selectedFilter != -1 && (
                    <div className='bg-template-bg-grey w-full lg:w-52 text-left'>
                        {/* <h2 className='font-bold text-lg pb-3'>Section 2 Filter</h2> */}
                        <div>
                            {topics[selectedFilter]?.attributes?.level_2?.map(
                                (topic, index) => (
                                    <button
                                        key={topic.id}
                                        value={topic.id}
                                        className={`list-none p-1 cursor-pointer text-lg hover:bg-template-input-border w-full text-left uppercase ${selectedSubFilter == topic.id
                                                ? 'bg-black text-white'
                                                : ''
                                            }`}
                                        onClick={handleSubFilterSelection}
                                    >
                                        {topic.title}
                                    </button>
                                )
                            )}
                        </div>
                    </div>
                )}
            </div>
        </>


    )
}

export default FiltersSection