import Image from 'next/image';
import Link from 'next/link';

import ticking_logo from '../assets/ticking-bomb-logo.png';
import facebook_logo from '../assets/social-icons/facebook.svg';
import youtube_logo from '../assets/social-icons/youtube.svg';
import reddit_logo from '../assets/social-icons/reddit.svg';
import twitter_logo from '../assets/social-icons/twitter.svg';
import gmail_logo from '../assets/social-icons/gmail.svg';
import gotomeeting_logo from '../assets/social-icons/gotomeeting.svg';
import podcast_logo from '../assets/social-icons/podcast.svg';
import skype_logo from '../assets/social-icons/skype.svg';
import telegram_logo from '../assets/social-icons/telegram.svg';
import vimeo_logo from '../assets/social-icons/vimeo.svg';
import zoom_logo from '../assets/social-icons/zoom.jpg';
import bitchute_logo from '../assets/social-icons/bitchute.jpg';
import clubhouse_logo from '../assets/social-icons/clubhouse.jpg';
import gettr_logo from '../assets/social-icons/gettr.jpg';
import rumble_logo from '../assets/social-icons/rumble.jpg';
import truthsocial_logo from '../assets/social-icons/truthsocial.jpg';
import link_logo from '../assets/social-icons/link.svg';
import { BACKEND_URL, PATHS } from '../utils/pages.constants';
import FeaturedPost from './FeaturedPost';

const selectIcon = (title) => {
	switch (title) {
		case 'facebook':
			return facebook_logo;
		case 'twitter':
			return twitter_logo;
		case 'youtube':
			return youtube_logo;
		case 'reddit':
			return reddit_logo;
		case 'contact':
			return gmail_logo;
		case 'gotomeeting':
			return gotomeeting_logo;
		case 'podcast':
			return podcast_logo;
		case 'skype':
			return skype_logo;
		case 'telegram':
			return telegram_logo;
		case 'vimeo':
			return vimeo_logo;
		case 'zoom':
			return zoom_logo;
		case 'bitchute':
			return bitchute_logo;
		case 'clubhouse':
			return clubhouse_logo;
		case 'gettr':
			return gettr_logo;
		case 'rumble':
			return rumble_logo;
		case 'truthsocial':
			return truthsocial_logo;
		default:
			return link_logo;
	}
};

const Footer = ({ footerContacts, footerPost }) => {
	return (
		<footer className='my-10 space-y-4'>
			<hr />
			{footerPost && <FeaturedPost post={footerPost} />}
			<div className='relative w-full h-28'>
				<Link href={PATHS.home}>
					<a>
						<Image
							src={ticking_logo}
							layout='fill'
							objectFit='contain'
							alt='ticking-bomb logo'
						/>
					</a>
				</Link>
			</div>
			<div className='flex justify-center gap-12 font-semibold text-center mb-5'>
				<Link href={PATHS.contact}>Contact Us</Link>
				<a href={PATHS.contact}>Advertise with us</a>
				<a href={PATHS.contact}>About us</a>
			</div>
			<div className='flex justify-center gap-4 lg:gap-8'>
				{footerContacts?.map((contact) => (
					<a
						href={contact.url + '?utm_source=tickingbomb.com'}
						key={contact.id}
					>
						<Image
							width={32}
							height={32}
							src={selectIcon(contact.title)}
							alt={contact.title}
						/>
					</a>
				))}
			</div>
			{footerPost?.footer_bottom_text &&
				(() => {
					let content = footerPost.footer_bottom_text
						.replace(/src="/g, `src=\"${BACKEND_URL}`)
						.replace(/&lt;hr&gt;/g, '<hr>');
					return (
						<div
							dangerouslySetInnerHTML={{ __html: content }}
							className='max-w-full text-center prose lg:prose-xl m-0'
						></div>
					);
				})()}
		</footer>
	);
};

Footer.defaultProps = {
	footerContacts: [],
	footerPost: {},
};

export default Footer;
