import Link from 'next/link';
import styles from '../styles/Home.module.css';

const Pagination = ({ pagination }) => {

	const pagesCount = pagination.pageCount// 100/10

	if (pagesCount === 1) return null;
	const pages = Array.from({ length: pagesCount }, (_, i) => i + 1);



	return (
		<div>
			<ul className={styles.pagination}>
				{pagination.page > 1 && (
					<Link
						href={`/exclusive?page=${pagination.page - 1}`}>
						<a className={`${styles.pageItem} text-lg`}>&laquo;</a>
					</Link>
				)}

				{pagination.pageCount > 10 ? (
					<>
						{pagination.page > 4 && (
							<>
								<Link
									href={`/exclusive?page=1`}
									key={1}
								>
									<li
										className={
											1 === pagination.page ? styles.pageItemActive : styles.pageItem
										}
									>
										<a className={styles.pageLink}>1</a>
									</li>
								</Link>
								<li className={styles.pageItem}>
									<span className={styles.pageLink}>...</span>
								</li>
							</>
						)}
						{pagination.page <= 4 ? (
							pages.slice(0, pagination.page === 4 ? 6 : 4).map((page) => (
								<Link
									href={`/exclusive?page=${page}`}
									key={page}
									className={
										page === pagination.page
											? styles.pageItemActive
											: styles.pageItem
									}
								>
									<a className={styles.pageLink}>{page}</a>
								</Link>
							))
						) : pagination.page > pagination.pageCount - 4 ? (
							pages.slice(-4).map((page) => (
								<Link
									key={page}
									href={`/exclusive?page=${page}`}
								>
									<li
										className={
											page === pagination.page
												? styles.pageItemActive
												: styles.pageItem
										}
									>
										<a className={styles.pageLink}>{page}</a>
									</li>
								</Link>
							))
						) : (
							<>
								{[
									pagination.page - 2,
									pagination.page - 1,
									pagination.page,
									pagination.page + 1,
									pagination.page + 2,
								].map((page) => (
									<Link
										key={page}
										href={`/exclusive?page=${page}`}
									>
										<li
											className={
												page === pagination.page
													? styles.pageItemActive
													: styles.pageItem
											}
										>
											<a className={styles.pageLink}>{page}</a>
										</li>
									</Link>
								))}
							</>
						)}
						{(pagination.page <= 4 || pagination.page < pages.length - 3) && (
							<>
								<li className={styles.pageItem}>
									<span className={styles.pageLink}>...</span>
								</li>
								<Link
									key={pages.length}
									href={`/exclusive?page=${pagination.pageCount}`}
								>
									<li
										className={
											pages.length === pagination.page
												? styles.pageItemActive
												: styles.pageItem
										}
									>
									<a className={styles.pageLink}>{pages.length}</a>
									</li>
								</Link>
							</>
						)}
					</>
				) : (
					pages.map((page) => (
						<Link
							key={page}
							href={`/exclusive?page=${page}`}
						>
							<li
								className={
									page === pagination.page ? styles.pageItemActive : styles.pageItem
								}
							>
								<a className={styles.pageLink}>{page}</a>
							</li>
						</Link>
					))
				)}
				{pagination.page < pagesCount && (
					<Link
						href={`/exclusive?page=${pagination.page + 1}`}>
						<a className={`${styles.pageItem} text-lg`}>&raquo;</a>
					</Link>
				)}
			</ul>
		</div>
	);
};

export default Pagination;
