import { BACKEND_URL, POST_COMPONENT_TYPE } from '../utils/pages.constants';
import Document from './Document';
import RumbleFrame from './RumbleFrame';
import TextLink from './TextLink';
import Tweet from './Tweet';
import YoutubeFrame from './YoutubeFrame';

const Post = ({ post, leftAlignment }) => {
	const postTypeRendering = (type) => {
		switch (type.__component) {
			case POST_COMPONENT_TYPE.TEXT:
				return (
					<li className='mb-1 list-none'>
						<TextLink data={type} />
					</li>
				);

			case POST_COMPONENT_TYPE.DOCUMENT:
				return (
					<li className='mb-1 list-none'>
						<Document data={type} />
					</li>
				);

			case POST_COMPONENT_TYPE.TWITTER:
				return <Tweet data={type} />;

			case POST_COMPONENT_TYPE.YOUTUBE:
				return <YoutubeFrame data={type} />;

			case POST_COMPONENT_TYPE.RUMBLE:
				return <RumbleFrame data={type} />;

			case POST_COMPONENT_TYPE.IMAGE:
				return (
					<a href={type.img_url + '?utm_source=tickingbomb.com'} target='_blank' rel='noopener noreferrer'>
						<img
							loading='lazy'
							className='object-contain max-w-full'
							style={{ width: type.img_size + 'rem' }}
							src={type.img_source ? type.img_source : type.image.url ||BACKEND_URL+ type?.image.data?.attributes?.url}
							alt='alternativeText'
							title={type.scroll_text}
						/>
					</a>
				);

			case POST_COMPONENT_TYPE.LONG_TEXT:
				let content = type.content
					.replace(/src="/g, `src=\"${BACKEND_URL}`)
					.replace(/&lt;hr&gt;/g, '<hr>');
				return (
					<div
						dangerouslySetInnerHTML={{ __html: content }}
						className='prose lg:prose-xl'
					></div>
				);

			default:
				break;
		}
	};


	return (
		<div className='px-2'>
			<div
				className={`mt-1 flex flex-col gap-2 ${leftAlignment ? 'items-start' : 'items-start lg:items-end'
					}`}
			>
				{post.show_title && (
					<h2 className='text-xl font-bold uppercase'>{post.post_title}</h2>
				)}
				{post.type?.map((type) => {
					return (
						<div key={type.__component + type.id} className='w-full'>
							{postTypeRendering(type)}
						</div>
					)
				})}
			</div>
			<hr className='mt-3' />
		</div>
	);
};

Post.defaultProps = {
	post: {},
	leftAlignment: true,
};

export default Post;
