import React from 'react';
import { BACKEND_URL } from '../utils/pages.constants';
import { formatDate } from '../utils/helpers';

const RssFeed = ({ rssData, logo, count,title,logo_size }) => {
	return (
		<div className='col-span-1 flex flex-col items-center gap-5'>
			{logo?.data ? (
				<a
					href={rssData?.link[0] + '?utm_source=tickingbomb.com'}
					target='_blank'
					rel='noreferrer'
				>
					<img
						src={BACKEND_URL + logo?.data?.attributes?.url}
						style={{ width: logo_size + 'rem' }}
						alt='line'
						className='text-center object-cover w-24'
					/>
				</a>
			) : (
				rssData?.title[0] && (
					<a
						href={rssData?.link[0] + '?utm_source=tickingbomb.com'}
						target='_blank'
						rel='noreferrer'
					>
						<h2 className='text-xl py-3 font-bold uppercase underline'>
							{title}
						</h2>
					</a>
				)
			)}
			<div className='flex flex-col gap-5'>
				{rssData?.item?.map(
					(child, index) =>
						index < count && (
							<a
							className="hover:underline visited:!text-[#878787]" 
								href={child.link[0] + '?utm_source=tickingbomb.com'}
								key={index}
								target='_blank'
								rel='noopener noreferrer'
							>
								<p className='text-xl text-left '>{child?.title[0]}</p>
								<p className='text-left'>{formatDate(child?.pubDate)}</p>
							</a>
						)
				)}
			</div>
		</div>
	);
};

export default RssFeed;
