import { classNames } from '../utils/helpers';

const RumbleFrame = ({ data, isFeatured }) => {
	return (
		<div
			// id = "video"
			className={classNames(
				'relative w-full h-full flex flex-col',
				isFeatured ? 'items-center' : 'items-start'
			)}
		>
			<h3
				className={classNames(data.title_emphasis && 'font-bold')}
				style={{
					color: data.hex_color,
					fontSize: `${data.text_size}rem`,
					minHeight: `${data.text_size}rem`,
				}}
			>
				{data.title}
			</h3>

			<div
				style={{
					position: 'relative',
					width: `${data.img_size}%`,
					aspectRatio: '16 / 9',
					maxWidth: '100%',
					overflow: 'hidden',
				}}
				className='max-w-3xl'
			>
				<iframe
					src={data.url}
					style={{
						position: 'absolute',
						top: 0,
						left: 0,
						width: '100%',
						height: '100%',
						border: 0,
					}}
					allowFullScreen
				></iframe>
			</div>
		</div>
	);
};

RumbleFrame.defaultFrame = {
	data: {
		title: '',
		url: '',
		img_size: 50,
		emphasis: false,
		hex_color: '#000000',
		text_size: 1,
	},
	isFeatured: false,
};

export default RumbleFrame;
