import React, { useState } from 'react';
import FiltersSection from './FiltersSection';
import { BACKEND_URL } from '../utils/pages.constants';
import RssFeed from './RssFeed';

export default function ThreeLevelNesting({ topics, filterType }) {
	const [selectedFilter, setSelectedFilter] = useState(0);
	const [selectedSubFilter, setSelectedSubFilter] = useState(null);


	const handleFilterSelection = (e) => {
		setSelectedFilter(e.target.value);
		setSelectedSubFilter(null);
	};
	const handleSubFilterSelection = (e) => {
		setSelectedSubFilter(e.target.value);
	};
	return (
		<section className='flex flex-col lg:flex-row justify-between w-full mt-7'>
			<FiltersSection
				topics={topics}
				selectedFilter={selectedFilter}
				selectedSubFilter={selectedSubFilter}
				handleFilterSelection={handleFilterSelection}
				handleSubFilterSelection={handleSubFilterSelection}
			/>
			<div className='flex-1 text-center p-5'>
				{/* Sections */}
				<h2 className='text-4xl pb-3 font-bold'>
					{topics[selectedFilter]?.attributes.title}
				</h2>
				{topics[selectedFilter] &&
					topics[selectedFilter]?.attributes?.level_2?.map(
						(level_2) =>
							(selectedSubFilter == level_2.id ||
								selectedSubFilter == null) && (
								<div className='mb-4' key={level_2.id}>
									{filterType == 2 ? (
										<Level3DoubleSide
											title={level_2.title}
											level3={level_2.links || []}
										/>
									) : (
										<Level3
											title={level_2.title}
											level3={level_2.links || []}
										/>
									)}
								</div>
							)
					)}
			</div>
			{/* <div className='w-full lg:w-72 p-6 bg-template-bg-grey flex justify-center items-center text-gray-600'>
				Ad
			</div> */}
		</section>
	);
}

function Level3({ title, level3 }) {
	return (
		<div>
			<h2 className='text-xl py-1 uppercase font-bold bg-template-black text-white'>
				{title}
			</h2>
			{level3.map((section) =>
				section.bold ? (
					<React.Fragment key={section.id}>
						{section?.logo?.data ? (
							<img
								src={BACKEND_URL + section?.logo?.data.attributes.url}
								alt='line'
								className='text-center'
							/>
						) : (
							<h2
								key={section.id}
								className='text-xl py-3 font-bold uppercase underline'
							>
								{section.title}
							</h2>
						)}
					</React.Fragment>
				) : (
					<div key={section.id}>
						<a
							href={section.url + '?utm_source=tickingbomb.com'}
							target={section.new_tab ? '_blank' : '_self'}
							rel='noopener noreferrer'
							className='pb-1 text-lg hover:underline'
						>
							{section.title}
						</a>
					</div>
				)
			)}
		</div>
	);
}

function Level3DoubleSide({ title, level3 }) {
	return (
		<div className='flex flex-col gap-5'>
			<h2 className='text-xl py-1 uppercase font-bold bg-template-black text-white'>
				{title}
			</h2>
			<div className='grid grid-cols-2 gap-10'>
				{level3.map((section, index) => {
					return (
						<RssFeed
							key={index}
							count={section?.count}
							title ={section?.title}
							logo_size ={section?.logo_size}
							rssData={section?.rss?.rss?.channel[0] || null}
							logo={section?.logo}
						/>
					);
				})}
			</div>
		</div>
	);
}
