import { classNames } from '../utils/helpers';

const YoutubeFrame = ({ data, isFeatured }) => {
	return (
		<div
			className={classNames(
				'relative w-full h-full flex flex-col ',
				isFeatured ? 'items-center' : 'items-start'
			)}
		>
			<h2
				className={classNames(data.title_emphasis && 'font-bold')}
				style={{
					color: data.hex_color,
					fontSize: `${data.text_size}rem`,
				}}
			>
				{data.title}
			</h2>
			<div
				style={{
					position: 'relative',
					width: `${data.img_size}%`,
					aspectRatio:  '16 / 9', 
					maxWidth: '100%',
					overflow: 'hidden',
				}}
				className='youtubeiframe max-w-3xl'
			>
				<iframe
					src={`https://www.youtube.com/embed/${data.video_id}`}
					style={{
						position: 'absolute',
						top: 0,
						left: 0,
						width: '100%',
						height: '100%',
						border: 0,
					}}
					allowFullScreen
				></iframe>
			</div>
		</div>
	);
};

YoutubeFrame.defaultFrame = {
	data: {
		title: '',
		video_id: '',
		img_size: 50,
		emphasis: false,
		hex_color: '#000000',
		text_size: 1,
	},
	isFeatured: false,
};

export default YoutubeFrame;
