// Next.js API route support: https://nextjs.org/docs/api-routes/introduction

import { API_URL } from '../../utils/pages.constants';

export default async function handler(req, res) {
	if (req.method !== 'POST')
		return res.status(400).json({
			error: {
				message: 'Invalid Request',
			},
		});
	const data = await (
		await fetch(`${API_URL}/api/messages`, {
			method: 'POST',
			headers: { 'Content-Type': 'application/json' },
			body: JSON.stringify(req.body),
		})
	).json();

	res.status(200).json(data);
}
