import styles from '../styles/Home.module.css';
import Head from 'next/head';
import PageLayout from '../components/PageLayout';
import {
	getCarpetBombsData,
	getConfigData,
	getHeaderFooterData,
} from '../utils/pages.data';
import Script from 'next/script';
import ThreeLevelNesting from '../components/ThreeLevelNesting';
import MetaHeader from '../components/MetaHeader';

export const getStaticProps = async () => {
	const resources = await getCarpetBombsData();
	const configData = await getConfigData();
	const header_data = await getHeaderFooterData();

	return {
		props: {
			topics: resources ? resources.data : [],
			configData: configData ? configData.data : {},
			...header_data,
		},
		revalidate: 1,
	};
};

const Resources = ({
	topics = [],
	configData,
	tickingHeader,
	footerPost,
	footerContacts,
}) => {
	return (
		<div className={styles.container}>
			<MetaHeader title='Carpet Bomb | Ticking Bomb'  />
			<PageLayout
				className='lg:px-14'
				pageTitle='Carpet Bomb'
				tickingHeader={tickingHeader}
				configUrl={configData?.attributes?.carpet_logo?.data?.attributes?.url}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<div className='flex flex-col items-center w-full'>
					<p className='text-lg'>
						{configData?.attributes?.carpet_description}
					</p>
				</div>

				<ThreeLevelNesting topics={topics} filterType={2} />
			</PageLayout>
		</div>
	);
};

export default Resources;
