import styles from '../styles/Home.module.css';
import Head from 'next/head';
import PageLayout from '../components/PageLayout';
import ReCAPTCHA from 'react-google-recaptcha';
import { useState } from 'react';
import { useRouter } from 'next/router';
import { getContactData, getHeaderFooterData } from '../utils/pages.data';
import { BACKEND_URL } from '../utils/pages.constants';
import MetaHeader from '../components/MetaHeader';

export const getStaticProps = async () => {
	const header_data = await getHeaderFooterData();
	const contact_data = await getContactData();
	return {
		props: {
			...header_data,
			contact_data,
		},
		revalidate: 1,
	};
};
const Contact = ({
	tickingHeader,
	footerPost,
	footerContacts,
	contact_data,
}) => {
	const [validated, setValidated] = useState(false);
	const router = useRouter();
	const [values, setValues] = useState({
		name: '',
		email: '',
		message: '',
	});

	const onRecaptchaChange = (value) => {
		if (value) setValidated(!!value);
	};

	const onChangeHandler = (name) => (event) => {
		setValues({ ...values, [name]: event.target.value });
	};
	const onSubmit = async (event) => {
		event.preventDefault();
		if (!validated) {
			alert('Please complete the reCaptcha first!');
			return;
		}
		const data = await (
			await fetch('/api/message', {
				method: 'POST',
				headers: { 'Content-Type': 'application/json' },
				body: JSON.stringify({ data: values }),
			})
		).json();
		if (data.error) {
			alert(data.error.message);
			return;
		}
		router.reload(window.location.pathname);
	};
	return (
		<div className={styles.container}>
			<MetaHeader title='Contact Us | Ticking Bomb'  />
			<PageLayout
				pageTitle='Contact Us'
				tickingHeader={tickingHeader}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<div className='w-full flex flex-col items-center'>
					{contact_data?.text &&
						(() => {
							let content = contact_data?.text
								.replace(/src="/g, `src=\"${BACKEND_URL}`)
								.replace(/&lt;hr&gt;/g, '<hr>');
							return (
								<div
									dangerouslySetInnerHTML={{ __html: content }}
									className='max-w-full text-center prose lg:prose-xl m-0'
								></div>
							);
						})()}
					<form className='flex flex-col items-stretch py-5 my-5'>
						<label className='font-bold uppercase text-sm'>Name</label>
						<input
							type='text'
							name='name'
							id='name'
							onChange={onChangeHandler('name')}
							className='mb-5 border border-template-input-border rounded-md p-1'
						/>

						<label className='font-bold uppercase text-sm'>Email</label>
						<input
							type='email'
							name='email'
							id='email'
							onChange={onChangeHandler('email')}
							className='mb-5 border border-template-input-border rounded-md p-1'
						/>

						<label className='font-bold uppercase text-sm'>Message</label>
						<textarea
							name='message'
							id='message'
							cols='40'
							rows='7'
							onChange={onChangeHandler('message')}
							className='mb-5 border border-template-input-border rounded-md p-1'
						></textarea>
						<div className='py-6'>
							<ReCAPTCHA
								sitekey={process.env.NEXT_PUBLIC_RECAPTCHA_SITE_ID}
								onChange={onRecaptchaChange}
							/>
						</div>
						<input
							type='submit'
							value='SEND MESSAGE'
							onClick={onSubmit}
							className='bg-template-black text-white p-4 text-sm rounded-md cursor-pointer'
						/>
					</form>
				</div>
			</PageLayout>
		</div>
	);
};

export default Contact;
