import styles from '../../styles/Home.module.css';
import PageLayout from '../../components/PageLayout';
import ExclusivePost from '../../components/ExclusivePost';
import Pagination from '../../components/Pagination';
import {
	getHeaderFooterData,
	getExclusiveData,
	getConfigData,
} from '../../utils/pages.data';
import MetaHeader from '../../components/MetaHeader';

export const getServerSideProps = async ({ query }) => {
	const exclusive = await getExclusiveData(query.page ?? 1);
	const configData = await getConfigData();
	const header_data = await getHeaderFooterData();

	return {
		props: {
			exclusive: exclusive ?? [],
			configData: configData.data ?? {},
			meta: exclusive?.meta ?? {},
			...header_data,
		},
	};
};
const Exclusive = ({
	exclusive,
	configData,
	tickingHeader,
	footerPost,
	footerContacts,
}) => {
	return (
		<div className={styles.container}>
			<MetaHeader title='Exclusive Blogs | Ticking Bomb'  />
			<PageLayout
				className='lg:px-14'
				pageTitle='Exclusive'
				tickingHeader={tickingHeader}
				configUrl={
					configData?.attributes?.exclusive_logo?.data?.attributes?.url
				}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<section className='flex flex-col lg:flex-row justify-between w-full mt-7'>
					<div className='w-full lg:w-36 p-6 bg-template-bg-grey flex justify-center items-center text-gray-600'>
						Ad
					</div>
					<div className='flex-1 text-center p-5'>
						<div className='flex flex-col gap-5'>
							<div className='flex flex-col gap-10'>
								{exclusive?.map((item) => (
									<ExclusivePost key={item.id} post={item} />
								))}
							</div>
							{exclusive?.meta?.pagination &&
								exclusive.meta.pagination.pageCount > 1 && (
									<Pagination pagination={exclusive.meta.pagination} />
								)}
						</div>
					</div>
					<div className='w-full lg:w-36 p-6 bg-template-bg-grey flex justify-center items-center text-gray-600'>
						Ad
					</div>
				</section>
			</PageLayout>
		</div>
	);
};

export default Exclusive;
