import Head from 'next/head';
import BodySection from '../components/BodySection';
import FeaturedPost from '../components/FeaturedPost';
import TrendingNews from '../components/TrendingNews';
import styles from '../styles/Home.module.css';
import PageLayout from '../components/PageLayout';
import { getHeaderFooterData, getHomepageData } from '../utils/pages.data';
import Script from 'next/script';
import MetaHeader from '../components/MetaHeader';

export const getStaticProps = async () => {
	let home_data = await getHomepageData();
	const header_data = await getHeaderFooterData();

	return {
		props: {
			...home_data,
			...header_data,
		},
		revalidate: 1,
	};
};

const Home = ({
	featuredPost,
	headerTitles,
	tickingHeader,
	leftTrending,
	rightTrending,
	body,
	footerPost,
	footerContacts,
}) => {
	return (
		<div className={styles.container}>
			<MetaHeader title='Ticking Bomb' />
			<PageLayout
				className='lg:px-14'
				tickingHeader={tickingHeader}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<main className='flex flex-col items-center'>
					{/* Featured Image */}
					{featuredPost && <FeaturedPost post={featuredPost} />}
				</main>
				{/* <div className='h-32 flex justify-center items-center text-3xl text-white border border-black bg-gray-400'>
					RESERVED BANNER
				</div> */}
				{/* Trending News */}
				<TrendingNews
					title={headerTitles?.trending_title}
					leftTrending={leftTrending}
					rightTrending={rightTrending}
				/>
				{/* <div className='h-32 flex justify-center items-center text-3xl text-white border border-black bg-gray-400'>
					RESERVED BANNER
				</div> */}
				{/* All News Section */}
				{body && <BodySection title={headerTitles?.body_title} body={body} />}
				{/* <div className='h-32 flex justify-center items-center text-3xl text-white border border-black bg-gray-400'>
					RESERVED BANNER
				</div> */}
			</PageLayout>
		</div>
	);
};

Home.defaultProps = {
	featured_post: {},
	headerTitles: {
		trending_title: '',
		body_title: '',
	},
};
export default Home;
