import styles from '../styles/Home.module.css';
import Head from 'next/head';
import PageLayout from '../components/PageLayout';
import {
	getConfigData,
	getHeaderFooterData,
	getToolsData,
} from '../utils/pages.data';
import Script from 'next/script';
import ThreeLevelNesting from '../components/ThreeLevelNesting';
import MetaHeader from '../components/MetaHeader';

export const getStaticProps = async () => {
	const toolsData = await getToolsData();
	const configData = await getConfigData();
	const header_data = await getHeaderFooterData();

	return {
		props: {
			topics: toolsData ? toolsData.data : [],
			configData: configData ? configData.data : {},
			...header_data,
		},
		revalidate: 1,
	};
};
const Tools = ({
	topics = [],
	configData,
	tickingHeader,
	footerPost,
	footerContacts,
}) => {
	return (
		<div className={styles.container}>
			<MetaHeader title='Tools | Ticking Bomb'/>
			<PageLayout
				className='lg:px-14'
				pageTitle='Tools'
				tickingHeader={tickingHeader}
				configUrl={configData?.attributes?.tools_logo?.data?.attributes?.url}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<div className='flex flex-col items-center w-full'>
					<p className='text-lg'>{configData?.attributes?.tools_description}</p>
				</div>
				<ThreeLevelNesting topics={topics} />
			</PageLayout>
		</div>
	);
};

export default Tools;
